#!/bin/sh

[ -z "${PYTHON}" ] && echo "ERROR: You must specify PYTHON= environment variable pointing to skynet python binary!" >&2 && exit 1

export SELFTEST_SERVICES="copier semaphorer procman"
[ -z "${SKYNET_SUPERVISOR_PATH}" ] && SKYNET_SUPERVISOR_PATH=/Berkanavt/supervisor
export SKYNET_SUPERVISOR_PATH=$(realpath ${SKYNET_SUPERVISOR_PATH})


echo "THIS TOOLS IS DEPRECATED"

do_header() {
    echo "***************************************************************"
    echo "$*"
    echo "THIS IS DEPRECATED SCRIPT BY THE WAY"
    echo "***************************************************************"
}

do_global_tests() {
    cat > runtests.py << PYCODE
if __name__ == '__main__':
    from pkg_resources import require
    require('pytest_xdist')
    require('pytest_pep8')

    import sys
    import os
    import pytest

    SKYNET_SUPERVISOR_PATH = os.path.realpath(os.environ['SKYNET_SUPERVISOR_PATH'])
    SELFTEST_SERVICES = os.environ.pop('SELFTEST_SERVICES', '')

    args = [
        '--ignore', SKYNET_SUPERVISOR_PATH,
        '--ignore', SKYNET_SUPERVISOR_PATH + '/skynet/python',
        '--ignore', SKYNET_SUPERVISOR_PATH + '/skynet/startup/supervisor',  # common dev path
        #'--pep8',  # enable pep8 checking
        '--tb=short',
        '-qq', '-rf'
    ]

    args = args + sys.argv[1:]

    for serviceToIgnore in SELFTEST_SERVICES.split():
        args.insert(0, '--ignore')
        args.insert(1, '%s/skynet/services/%s' % (os.environ['SKYNET_SUPERVISOR_PATH'], serviceToIgnore))

    args.append(os.environ['SKYNET_SUPERVISOR_PATH'] + '/skynet')

    raise SystemExit(pytest.main(args))
PYCODE

    cat > pytest.ini << PYTESTINI
[pytest]
python_files = test*.py
pep8ignorefiles = *_pb2.py
norecursedirs = .* _* *~
PYTESTINI

    do_header GLOBAL TESTS

    ${PYTHON} ./runtests.py "$@"
    RET_COMMON=$?
    rm -rf runtests.py* pytest.ini
}

do_service_tests() {
    for srv in ${SELFTEST_SERVICES}; do
        do_header "SERVICE $(echo ${srv} | tr [:lower:] [:upper:])"

        cd services/${srv}
        if [ ! -x ./build.sh ]; then
            echo "ERROR: no executable build.sh in $(pwd)"
            cd - >/dev/null
            continue
        fi

        ./build.sh clean >/dev/null
        ./build.sh bundle >/dev/null
        ./build.sh test -qq
        ret=$?

        [ ${ret} -eq 0 ] || SRV_FAIL=1
        [ ${ret} -eq 0 ] && ./build.sh clean >/dev/null

        cd - >/dev/null
    done
}

RET_COMMON=0
SRV_FAIL=0

[ -z "${NO_GLOBAL_TESTS}" ] && do_global_tests "$@"
[ -z "${NO_SERVICE_TESTS}" ] && do_service_tests "$@"

[ ! ${RET_COMMON} -eq 0 ] && exit 1
[ ${SRV_FAIL} -eq 1 ] && exit 1

