import py
import os


def getRootImpl(path):
    parts = py.path.local(path).parts()
    for part in reversed(parts):
        if part.basename == 'supervisor':
            return part.strpath

    return None


def getRoot():
    ret = None

    if not ret:
        # First try -- just attempt to find supervisor
        ret = getRootImpl(__file__)

    if not ret:
        # Second try -- attempt to find supervisor after reading /skynet symlink
        npath = [p for p in os.path.abspath(__file__).split(os.sep) if p]
        if __file__.startswith('/') and npath and npath[0] == 'skynet' and os.path.islink('/skynet'):
            fn = os.path.join(
                os.readlink('/skynet'),
                os.sep.join(npath[1:])
            )
            ret = getRootImpl(fn)

    if not ret:
        # Third try -- read all links
        ret = getRootImpl(os.path.realpath(__file__))

    if not ret:
        # Final attempt -- maybe we have environ var...
        if 'SKYNET_SUPERVISOR_PATH' in os.environ:
            return os.path.realpath(os.environ['SKYNET_SUPERVISOR_PATH'])

        # Failed =(
        from kernel.util.errors import SkynetError
        raise SkynetError('Cant determine supervisor path! __file__ is {0}', __file__)

    return ret
