#!/usr/bin/env python

import shutil
from os import path, listdir, unlink


def _remove(p):
    if path.exists(_path) or path.islink(_path):
        if path.islink(p) or path.isfile(p):
            unlink(p)
            print 'FILE ' + p
        elif path.isdir(p):
            shutil.rmtree(p, ignore_errors=True)
            print 'DIR  ' + p
        else:
            print '!!!! ' + p


if __name__ == '__main__':

    sky_path = path.realpath(path.join(path.dirname(__file__), '..'))

    services = (
        # not all services here
        'copier',             # NEW
    )

    for service in listdir(path.join(sky_path, 'services')):
        for dir in ['build', 'snapshot']:
            _path = path.join(sky_path, 'services', service, dir)
            _remove(_path)

    _path = path.join(sky_path, 'startup', 'supervisor')
    _remove(_path)

    _path = path.join(sky_path, 'services', 'batch', 'skynet_batch')
    _remove(_path)

    _path = path.join(sky_path, 'services', 'batch', 'svninfo.py')
    _remove(_path)

    _path = path.join(sky_path, 'services', 'skybone-coord', '.doit.db')
    _remove(_path)

    _path = path.join(sky_path, 'services', 'skybone-coord', 'doc')
    _remove(_path)
