#!/usr/bin/env python
"""
This script can quickly bootstrap skynet development
environment in some dir, making useful symlinks.
"""

import os
import sys
import textwrap
from os import path
import subprocess


if len(sys.argv) < 2:
    # Try to print ./build.py help as well
    print >> sys.stderr, 'Usage: {0} [options] <path to dev directory>'.format(sys.argv[0])
    proc = subprocess.Popen([sys.executable, './build.py', '-h'], stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    stdout = proc.communicate()[0].splitlines()
    for idx, line in enumerate(stdout):
        if line.startswith('optional arguments'):
            break
    print
    print '(build.py)',
    print '\n'.join(stdout[idx:])
    raise SystemExit(1)
else:
    devdir = sys.argv[-1]

args = sys.argv[1:-1]

print 'Creating dev environment in {0}'.format(path.abspath(devdir))
supervisorPath = path.join(path.abspath(devdir), 'supervisor')

excludeServices = ['skynet', 'shardstates', 'skybone', 'skybone-coord', 'copier', 'kqueue', 'keychain', 'logrotated']

proc = subprocess.Popen(
    [
        sys.executable, '-u', './build.py',
        '--builddir', supervisorPath,     # builddir-supervisor hack :)
        '--variant', 'devel',             # devel mode
        '--components', 'base,services',  # by default -- dont build docs
    ] +
    ['-e%s' % s for s in excludeServices] + args,
    stdout=None, stderr=subprocess.STDOUT
)
stdout = proc.communicate()[0]
if proc.returncode != 0:
    print >> sys.stderr, stdout
    raise SystemExit(proc.returncode)

os.makedirs(os.path.join(supervisorPath, 'var'))
os.chmod(os.path.join(supervisorPath, 'var'), 0777)

env = os.environ.copy()
env.update({'PYTHONPATH': ':'.join([path.join(supervisorPath, 'skynet')] + env.get('PYTHONPATH', '').split(':'))})
subprocess.Popen(
    [
        sys.executable, '-uc', textwrap.dedent("""
            import sys
            import library.config

            sys.stdout.write('Update configuration registry' + ' ' * 9)
            conf_id = library.config.update()
            print('Not changed.' if not conf_id else 'Configuration ID #%s' % conf_id)
        """),
    ],
    env=env,
).wait()

fp = open(path.join(supervisorPath, 'activate'), 'wb')
fp.write('''# source with file in bash!

_SKY_OLD_PS1="$PS1"
_SKY_OLD_PYTHON="$PYTHON"
_SKY_OLD_PYTHONPATH="$PYTHONPATH"

PS1="(skydev) $PS1"
PYTHON="%(python)s"
PYTHONPATH="%(pythonpath)s:$PYTHONPATH"
SKYNET_SUPERVISOR_PATH="%(supervisor)s"
[ "${PYTHONPATH: -1}" = ":" ] && PYTHONPATH=${PYTHONPATH%%?}

export PS1 PYTHON PYTHONPATH

deactivate() {
    export PS1="$_SKY_OLD_PS1"
    export PYTHON="$_SKY_OLD_PYTHON"
    export PYTHONPATH="$_SKY_OLD_PYTHONPATH"
}
''' % {
    'python': sys.executable,
    'pythonpath': supervisorPath + '/skynet',
    'supervisor': supervisorPath,
})

print
print 'To work with skynet services just type:'
print '  source %s/activate' % (supervisorPath, )
