#!/usr/bin/env bash
### BEGIN INIT INFO
# Provides:          skycored
# Required-Start:    $local_fs
# Required-Stop:     $local_fs
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: starting of skycore daemon
# Description:       this file should be used to start skynet skycore daemon at system start
#
### END INIT INFO

# Author: agri@

# Do NOT "set -e"

# PATH should only include /usr/* if it runs after the mountnfs.sh script
PATH=/sbin:/usr/sbin:/bin:/usr/bin
DESC="Skycore Service"
NAME=skycored

: ${skycored_user="skynet"}
: ${skycored_dir="/skynet"}

DAEMON="${skycored_dir}/startup/skyctl"
PIDFILE=/var/run/$NAME.pid
SCRIPTNAME=/etc/init.d/$NAME
OPTS=""

# Exit if the package is not installed
if [ "$1" != 'stop' ];
then
    [ -x "$DAEMON" ] || exit 1
else
    [ -x "$DAEMON" ] || exit 0
fi

# Read configuration variable file if it is present
[ -r /etc/default/$NAME ] && . /etc/default/$NAME

if [ -f /lib/init/vars.sh ]; then
    # Load the VERBOSE setting and other rcS variables
    . /lib/init/vars.sh
fi

# Define LSB log_* functions.
if [ -f /lib/lsb/init-functions ]; then
    # Using debian-style LSB.
    # Depend on lsb-base (>= 3.0-6) to ensure that this file is present.
    . /lib/lsb/init-functions
elif [ -f /etc/init.d/functions ]; then
    # Using RHEL-specific stuff.
    . /etc/init.d/functions
    log_end_msg() {
        if [ "$1" -eq 0 ]; then
            echo_success
            echo
        else
            echo_failure
            echo
        fi
    }
    log_daemon_msg() {
        echo -n "$*"
    }
else
    COL=$((${COLUMNS} - 8))
    NORMAL="\\033[0;39m"         # Standard console grey
    SUCCESS="\\033[1;32m"        # Success is green
    FAILURE="\\033[1;31m"        # Failures are red
    BRACKET="\\033[1;34m"        # Brackets are blue
    SET_COL="\\033[${COL}G"      # at the $COL char

    log_daemon_msg() {
        echo -n "$*"
    }
    log_end_msg() {
        if [ "$1" -eq 0 ]; then
            echo -e "${SET_COL}${BRACKET}[${SUCCESS}  OK  ${BRACKET}]${NORMAL}"
        else
            echo -e "${SET_COL}${BRACKET}[${FAILURE} FAIL ${BRACKET}]${NORMAL}"
        fi
    }
fi

#
# Function that starts the daemon/service
#
do_start()
{
    # Return
    #   0 if daemon has been started
    #   1 if daemon was already running
    #   2 if daemon could not be started
    $DAEMON $OPTS init "$@" || return 2
}

#
# Function that starts the daemon/service
#
do_autostart()
{
    # Return
    #   0 if daemon has been started
    #   1 if daemon was already running
    #   2 if daemon could not be started
    $DAEMON $OPTS autoinit --start-services >/dev/null 2>&1 || return 2
}

#
# Function that restarts the daemon/service
#
do_restart()
{
    # Return
    #   0 if restarted
    do_stop $OPTS "$@" && do_start $OPTS "$@" || return 2
}

#
# Function that stops the daemon/service
#
do_stop()
{
	# Return
	#   0 if daemon has been stopped
	#   1 if daemon was already stopped
	#   2 if daemon could not be stopped
	#   other if a failure occurred
    $DAEMON $OPTS shutdown "$@" || return 2
    return 0
}

do_check()
{
    if [ "$#" -eq 0 ];
    then
        $DAEMON check skynet
        return $?
    else
        $DAEMON check "$@"
        return $?
    fi
}

if [ "$1" = "--no-lock" ]; then
    OPTS="${OPTS} --no-lock"
    shift 1
fi

case "$1" in
  start)
	[ "$VERBOSE" != no ] && log_daemon_msg "Starting $DESC"
	shift
	do_start --start-services --wait 180 "$@"
	res="$?"
	case "$res" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	exit $res
	;;

  autostart)
	[ "$VERBOSE" != no ] && log_daemon_msg "Starting $DESC"
	shift
	do_autostart "$@"
	res="$?"
	case "$res" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	exit $res
	;;

  stop)
	[ "$VERBOSE" != no ] && log_daemon_msg "Stopping $DESC"
	shift
	do_stop --keep-autostart --stop-services "$@"
	res="$?"
	case "$res" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	exit $res
	;;

  restart)
	[ "$VERBOSE" != no ] && log_daemon_msg "Restarting $DESC"
	shift
	do_restart "$@"
	res="$?"
	case "$res" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	exit $res
	;;

  check)
	[ "$VERBOSE" != no ] && log_daemon_msg "Checking $DESC"
	shift
        do_check "$@"
        res="$?"
        case "$res" in
		0) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		1) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	exit $res
	;;

  *)
	echo "Usage: $SCRIPTNAME {start|stop|restart|autostart}" >&2
	exit 3
	;;
esac

:
