from kernel.util.pytest import TestBrick
from cmd import cmd


class Hosts(TestBrick):
    """
    Returns list of alive hosts.
    """

    def setUp(self, request):
        def _hosts(hostname_template = 'client-%d', max_count=15, min_count=0):
            hosts = map(lambda x: hostname_template % x, range(1, max_count))
            alive_hosts = filter(lambda x: cmd(['ping', '-o', '-t1', '%s' % x], skipifnotavailable=False)[2]==0, hosts)

            if len(alive_hosts) == 0 and min_count == 0:
                return ['+localhost']

            assert len(alive_hosts) > min_count, "All hosts are dead"

            alive_hosts = (map(lambda x: "+%s" % x, alive_hosts))
            return alive_hosts
        return _hosts
