from __future__ import print_function, absolute_import

from library.sky import hosts


def test_hosts_list():
    assert \
        hosts.braceExpansion(['foo-{1,2,3}', 'foo-{4..5}.yandex.ru']) \
        == \
        'foo-1 foo-2 foo-3 foo-4.yandex.ru foo-5.yandex.ru'.split()

    assert \
        hosts.braceExpansion(['foo-{1,2,3}-{4..5}']) \
        == \
        'foo-1-4 foo-2-4 foo-3-4 foo-1-5 foo-2-5 foo-3-5'.split()

    assert hosts.braceExpansion(['foo-{004..006}-x']) == 'foo-004-x foo-005-x foo-006-x'.split()

    assert hosts.braceExpansion(['foo-{04..006}-x']) == 'foo-004-x foo-005-x foo-006-x'.split()

    assert hosts.braceExpansion(['foo-{004..6}-x']) == 'foo-004-x foo-005-x foo-006-x'.split()

    assert hosts.braceExpansion(['foo-{9..11}-x']) == 'foo-9-x foo-10-x foo-11-x'.split()

    assert hosts.braceExpansion(['foo-{09..11}-x']) == 'foo-09-x foo-10-x foo-11-x'.split()

    assert hosts.braceExpansion(['foo-{009..11}-x']) == 'foo-009-x foo-010-x foo-011-x'.split()

    assert hosts.braceExpansion(['foo-{4..5}-x']) == 'foo-4-x foo-5-x'.split()
