import sys
from api.kqueue import Client

class TestRunner(object):
    def __init__(self, code):
        self.code = code

    def run(self):
        result = None
        exec self.code
        return result


def test_simple():
    import api
    code = '''
import api
assert api
'''

    for host, result, error in Client().run(['localhost'], TestRunner(code)).wait():
        assert not error
        assert result is None


def test_module_transfer(tmpdir):
    path = sys.path[:]

    try:
        import api
        tmpdir.join('testmod.py').open('w').write('somefunc = lambda: 123\n')
        sys.path.insert(0, tmpdir.strpath)

        import testmod

        code = '''
import testmod
result = testmod.somefunc()
'''
        for host, result, error in Client().run(['localhost'], TestRunner(code)).wait():
            assert not error
            assert result == 123
    finally:
        sys.modules.pop('testmod')
        sys.path = path

        tmpdir.join('testmod.py').remove()


def test_package_transfer(tmpdir):
    path = sys.path[:]

    try:
        packdir = tmpdir.join('testpack').ensure(dir=1)
        packdir.join('__init__.py').open('w').write('\n')
        packdir.join('testmod.py').open('w').write('somefunc = lambda: 321\n')

        sys.path.insert(0, tmpdir.strpath)

        import testpack

        code = '''
import testpack.testmod
result = testpack.testmod.somefunc()
'''
        for host, result, error in Client().run(['localhost'], TestRunner(code)).wait():
            assert not error
            assert result == 321
    finally:
        sys.modules.pop('testpack')
        sys.path = path

        packdir.remove()


def test_namespace_package_transfer(tmpdir):
    path = sys.path[:]

    try:
        pack1dir = tmpdir.join('pack1').ensure(dir=1)
        pack2dir = tmpdir.join('pack2').ensure(dir=1)

        nspack1 = pack1dir.join('nspack').ensure(dir=1)
        nspack2 = pack2dir.join('nspack').ensure(dir=1)

        nspack1.join('__init__.py').open('w').write(
            '__import__("pkg_resources").declare_namespace(__name__)\n' \
            'somefunc = lambda: 123\n'
            'somefuncA = lambda: 123\n'
        )
        nspack2.join('__init__.py').open('w').write(
            '__import__("pkg_resources").declare_namespace(__name__)\n' \
            'somefunc = lambda: 321\n'
            'somefuncB = lambda: 321\n'
        )

        nspack1.join('testmod.py').open('w').write('modfunc = lambda: 111\n')
        nspack1.join('vasya.py').open('w').write('vasya = lambda: "vasyooook!"\n')
        nspack2.join('testmod.py').open('w').write('modfunc = lambda: 222\n')
        nspack2.join('petya.py').open('w').write('petya = lambda: "pyatachooook!"\n')


        subnspack1 = nspack1.join('subpack').ensure(dir=1)
        subnspack2 = nspack2.join('subpack').ensure(dir=1)

        for p in (subnspack1, subnspack2):
            p.join('__init__.py').open('w').write('__import__("pkg_resources").declare_namespace(__name__)\n')
            p.join('submod.py').open('w').write('hui = lambda: "pipiska"\n')

        subpack1 = subnspack1.join('subpack1').ensure(dir=1)
        subpack2 = subnspack2.join('subpack2').ensure(dir=1)

        subpack1.join('__init__.py').open('w').write('modfunc = lambda: "subpack1"\n')
        subpack2.join('__init__.py').open('w').write('modfunc = lambda: "subpack2"\n')

        sys.path.insert(0, pack1dir.strpath)
        sys.path.insert(1, pack2dir.strpath)

        import nspack

        assert nspack.somefunc() == 123
        assert nspack.somefuncA() == 123
        assert nspack.somefuncB() == 321

        import nspack.testmod
        assert nspack.testmod.modfunc() == 111

        import nspack.vasya
        assert nspack.vasya.vasya() == 'vasyooook!'

        import nspack.petya
        assert nspack.petya.petya() == 'pyatachooook!'

        from nspack.subpack import subpack1, subpack2, submod
        assert subpack1.modfunc() == 'subpack1'
        assert subpack2.modfunc() == 'subpack2'
        assert submod.hui() == 'pipiska'

        code = '''
import nspack
import nspack.testmod
from nspack.vasya import vasya
from nspack.petya import petya
from nspack.subpack import subpack1, subpack2, submod

assert nspack.somefunc() in (123, 321), 'nspack.somefunc() in (123, 321) (got %r)' % nspack.somefunc()
assert hasattr(nspack, 'somefuncB') or hasattr(nspack, 'somefuncA')
# assert nspack.somefuncB() == 321
# assert nspack.somefuncA() == 123  # this does not works atm

assert nspack.testmod.modfunc() in (111, 222)
assert vasya() == 'vasyooook!', 'vasya loh!'
assert petya() == 'pyatachooook!', 'petya loh!'

assert subpack1.modfunc() == 'subpack1'
assert subpack2.modfunc() == 'subpack2'
assert submod.hui() == 'pipiska', 'Nu eto hrenoten kakaya-to'

'''

        for host, result, error in Client().run(['localhost'], TestRunner(code)).wait():
            assert not error
            assert result is None


    finally:
        sys.modules.pop('nspack')
        sys.path = path

        pack1dir.remove()
        pack2dir.remove()
