import py
import socket
import pytest

from kernel.util.pytest import TestBrick
from cmd import cmd


class ResourceShare(TestBrick):
    def __share(self, resource, basedir=None):
        result = cmd(['sky',
                      'share',
                      '%s' % resource],
                      cwd=resource.join('..').strpath)
        assert  result[2] == 0, result

        resource_id = result[0].strip()
        print "*** shared resource id:%s" % resource_id

        result = cmd(['sky',
                      'files',
                      resource_id])
        assert result[2] == 0, result
        shared_items = eval(result[0])

        print "*** shared items: %s" % shared_items

        shared_items = [x['name'] for x in  shared_items]

        for item in [resource] if resource.check(dir=0) else resource.visit(fil=lambda x: x.check(file=1)):
            assert item.strpath.lstrip('/') in shared_items

        return resource_id

    def setUp(self, request):
        return self.__share


class ResourceGet(TestBrick):

    def __get(self, resource, resource_id, hosts, basedir=None):
        result = cmd(["sky", "run", "mkdir -p %s" % resource.dirname] + hosts)

        # NB! wordir for remote run sky get is /tmp
        #download_command = ' sky get %s %s' % ('' if basedir is None else '-d %s' % basedir, resource_id)
        download_command = 'cd %s; sky get -w %s %s' % (
            resource.dirname, '' if basedir is None else '-d %s' % basedir, resource_id
        )

        result = cmd(["sky",
                      "run",
                      "%s" % download_command] +
                      hosts)

        assert result[2] == 0, result

    def setUp(self, request):
        return self.__get


class ResourceUpload(TestBrick):
    def setUp(self, request):
        def _upload(local_path, remote_path, hosts):
            result = cmd(["sky", "upload", local_path, remote_path] + hosts)
            assert result[2] == 0, result
        return _upload


class ResourceDownload(TestBrick):
    def setUp(self, request):
        def _download(remote_path, local_path, hosts):
            result = cmd(["sky", "download", remote_path, local_path] + hosts)
            assert result[2] == 0, result
        return _download


class ResourceEquals(TestBrick):
    def setUp(self, request):
        def _check(resource, hosts, localpath=None, remotepath=None):
            localpath = resource if localpath is None else localpath
            remotepath = resource if remotepath is None else remotepath

            for item in [resource] if resource.check(dir=0) else resource.visit(fil=lambda x: x.check(file=1)):
                remote_res = remotepath.join(resource.bestrelpath(item))
                local_res = localpath.join(resource.bestrelpath(item))
                print "*** compare md5 for %s" % local_res.strpath
                print "    and %s" % remote_res.strpath
                print "    on hosts: %s " % " ".join(hosts)
                result = cmd(["sky",
                          "run",
                          "$(which md5 >/dev/null 2>&1) && MD5='md5 -r' || MD5=md5sum;"
                          "[ $($MD5 %s | cut -c -32) = '%s' ]" % (remote_res.strpath, local_res.computehash())] +
                          hosts)
                assert result[2] == 0, result
        return _check


def resource_case_0(tmpdir):
    resource = tmpdir.join('resource')
    resource.write('')
    resource.ensure()
    return resource


def resource_case_1(tmpdir):
    resource = tmpdir.join('resource')
    resource.write('################')
    resource.ensure()
    return resource


def resource_case_2(tmpdir):
    resource = tmpdir.mkdir('resource')
    resource.ensure(dir=1)

    dir1 = resource.mkdir('dir1')
    dir1.ensure(dir=1)

    file2 = dir1.join('file2')
    file2.write('dsafffffffffff')
    file2.ensure()

    file1 = resource.join('file1')
    file1.write('testasdsadsadassfvcdfcfrdgsfdssacvds')
    file1.ensure()

    link1 = resource.join('link1')
    link1.mksymlinkto(file1)
    link1.ensure(link=1)

    return resource


def test_share_files_get_cases(resource_testcase, tmpdir, resourceShare, resourceGet, resourceEquals, hosts):
    hosts = hosts()
    resource = resource_testcase(tmpdir)
    resource_id = resourceShare(resource)
    resourceGet(resource, resource_id, hosts)
    resourceEquals(resource, hosts)


def test_upload_cases(resource_testcase, tmpdir, resourceUpload, resourceDownload, resourceEquals, hosts):
    hosts = hosts()
    resource = resource_testcase(tmpdir)
    resourceUpload(resource.strpath, resource.dirname, hosts)
    resourceEquals(resource, hosts)
    resourceDownload(resource.strpath, resource.dirname, hosts)
    for host in hosts:
        resourceEquals(resource,
                       localpath=resource.new(dirname=resource.join('../%s' % socket.getfqdn(name=host.lstrip('+')))),
                       hosts=[host])


def pytest_generate_tests(metafunc):
    metafunc.addcall(funcargs=dict(resource_testcase=resource_case_0))
    metafunc.addcall(funcargs=dict(resource_testcase=resource_case_1))
    metafunc.addcall(funcargs=dict(resource_testcase=resource_case_2))
