from cmd import cmd


def simple_command_case(hosts):
    return {
        'command': ['sky', 'run', 'hostname'] + hosts,
        'retcode': 0
    }


def badcommand_case(hosts):
    return {
        'command': ['sky', 'run', 'badcommand'] + hosts,
        'retcode': 1
    }


def unresolved_hosts_case(hosts):
    return {
        'command': ['sky', 'run', 'hostname'] + ['+fakefake'],
        'retcode': 2
    }


def unresolved_and_resolved_hosts_case(hosts):
    return {
        'command': ['sky', 'run', 'hostname'] + ['+fakefake', '+localhost'],
        'retcode': 1
    }


def empty_host_string_case(hosts):
    return {
        'command': ['sky', 'run', 'hostname'],
        'retcode': 2
    }


def command_chain_case(hosts):
    return {
        'command': [
            'sky', 'run',
            'head /dev/urandom | $(which md5 >/dev/null 2>&1 && echo md5 || echo md5sum)'
        ] + hosts,
        'retcode': 0
    }


def empty_stderr_stdout_case_1(hosts):
    return {
        'command': ['sky', 'run', 'false'] + hosts,
        'retcode': 1
    }


def empty_stderr_stdout_case_2(hosts):
    return {
        'command': ['sky', 'run', '-c', 'false'] + hosts,
        'retcode': 1
    }


def simple_command_case(hosts):
    return {
        'command': ['sky', 'run', 'hostname'] + hosts,
        'retcode': 0
    }


def t_option_case_1(hosts):
    return {
        'command': ['sky', 'run', '-t', '2', 'sleep 1'] + hosts,
        'retcode': 0
    }


def t_option_case_2(hosts):
    return {
        'command': ['sky', 'run', '-t', '1', 'sleep 2'] + hosts,
        'retcode': 1
    }


def test_sky_run(command_testcase, hosts):
    hosts = hosts()
    testcase = command_testcase(hosts)
    result = cmd(testcase['command'])
    assert result[2] == testcase['retcode'], " ".join([
        'command: %s\n' % " ".join(testcase['command']),
        '\nexpected retcode: %s\n' % testcase['retcode'],
        'actulal retcode: %s\n' % result[2],
        'stdout: \n%s\n' % result[0],
        'stderr: \n%s\n' % result[1]
    ])


def pytest_generate_tests(metafunc):
    metafunc.addcall(funcargs=dict(command_testcase=simple_command_case))
    metafunc.addcall(funcargs=dict(command_testcase=badcommand_case))
    metafunc.addcall(funcargs=dict(command_testcase=unresolved_hosts_case))
    metafunc.addcall(funcargs=dict(command_testcase=unresolved_and_resolved_hosts_case))
    metafunc.addcall(funcargs=dict(command_testcase=empty_host_string_case))
    metafunc.addcall(funcargs=dict(command_testcase=command_chain_case))
    metafunc.addcall(funcargs=dict(command_testcase=empty_stderr_stdout_case_1))
    metafunc.addcall(funcargs=dict(command_testcase=empty_stderr_stdout_case_2))
    metafunc.addcall(funcargs=dict(command_testcase=t_option_case_1))
    metafunc.addcall(funcargs=dict(command_testcase=t_option_case_2))
