import logging

from smarttv.alice.mm_backend.channels import vh_api
from smarttv.alice.mm_backend.common.helpers import IItemFinder
from smarttv.alice.mm_backend.common.gallery import IGalleryBuilder, Gallery, GalleryItem

logger = logging.getLogger(__name__)


class ChannelType:
    cable = 0
    efir = 1


class Channel:
    def __init__(self, name: str, id: int, type: ChannelType):
        # возможно имя нужно нормализовывать + сравнивать корзинки с учетом обогащения синонимами (не пустое пересечение сетов - eq return true)
        self.name = name
        self.id = id
        self.type = type

    def __hash__(self):
        return hash(self.name)

    def __eq__(self, other):
        return self.name == other.name

    def __repr__(self):
        return 'channel "%s"' % self.name


class ChannelsManager(IGalleryBuilder, IItemFinder):
    def __init__(self, cable_channels_info, user_geo_id):
        self.channels = dict()

        # efir channels first
        for title, channel_id in vh_api.get_channels(user_geo_id):
            self._add_channel(title, channel_id, ChannelType.efir)

        if cable_channels_info is None:
            logger.info('cable channels info is none')

        for info in cable_channels_info:
            for item in info['list']:
                self._add_channel(item['name'], item['id'], ChannelType.cable)

    def _add_channel(self, name, id, type):
        self.channels[id] = Channel(name.lower(), id, type)

    @property
    def gallery(self):
        return Gallery([GalleryItem(item.id, item.name) for item in self.channels.values()])

    def find_item(self, id):
        return self.channels.get(id)
