# noinspection PyUnresolvedReferences
from alice.megamind.protos.scenarios.response_pb2 import TScenarioRunResponse

from smarttv.alice.mm_backend.common import livetv_url_scheme
from smarttv.alice.mm_backend.channels import vh_content_scheme
from smarttv.alice.mm_backend.channels.channel import ChannelType
from smarttv.alice.mm_backend.common.helpers import get_info, IItemFinder, get_item_attr


class Phrases:
    @staticmethod
    def success(channel_name):
        return 'Переключаю на канал %s' % channel_name

    @staticmethod
    def fail():
        return 'Данный канал не доступен на вашем телевизоре'

    @staticmethod
    def multiple_choice():
        return 'Я нашла сразу несколько похожих каналов, но я пока не умею делать выбор среди них.'


def get_run_response(results, finder: IItemFinder, extra, user_req):
    run_response = TScenarioRunResponse()
    if len(results) == 0:
        run_response.ResponseBody.Layout.OutputSpeech = Phrases.fail()
    elif len(results) == 1:
        id = results[0]
        item = finder.find_item(id)
        assert item, 'id not assigned with any name: id=%s' % id
        name = get_item_attr(finder.find_item(id), 'name')

        run_response.ResponseBody.Layout.OutputSpeech = Phrases.success(name)

        directive = run_response.ResponseBody.Layout.Directives.add()
        directive.OpenUriDirective.Name = 'tv channel switcher'

        if item.type == ChannelType.cable:
            channels_group_info = get_info(id, extra)
            directive.OpenUriDirective.Uri = livetv_url_scheme.switch_channel_uri(
                channels_group_info['authority'],
                channels_group_info['input_type'],
                id
            )
        elif item.type == ChannelType.efir:
            directive.OpenUriDirective.Uri = vh_content_scheme.switch_channel_uri(id)
        else:
            assert False, 'unexpected channel type'
    else:
        # todo: tmp decision
        run_response.ResponseBody.Layout.OutputSpeech = Phrases.multiple_choice()

    return run_response
