from typing import List, Tuple, Any

from furl import furl
import requests
import logging
from operator import itemgetter

logger = logging.getLogger(__name__)


class VhApi:
    partial_url = 'https://frontend.vh.yandex.ru/v23/'

    common_params = {
        'from': '',
        'service': 'ya-tv-app',
    }

    def __init__(self):
        self.url = furl(self.partial_url)
        self.url.set(self.common_params)

    @property
    def vh_url(self):
        return self.url.copy()

    def _make_request(self, path, params: List[Tuple[str, Any]]):
        vh_url = self.vh_url
        vh_url /= path
        for name, value in params:
            vh_url.args[name] = value

        return requests.get(vh_url.url, verify=False)

    def channels_regions(self, region: int):
        return self._make_request('channels_regions', [('with_filtration', 1), ('region', region)])


def get_channels(region: int, api: VhApi = None) -> List[Tuple]:
    api = api or VhApi()
    response = api.channels_regions(region)
    response.raise_for_status()

    try:
        return map(itemgetter('title', 'channel_id'), response.json()['set'])
    except KeyError as ex:
        logger.warning(
            'vh frontend api response, endpoint=channels_regions return bad structure response: key %s is absent', ex)
        return []
