from smarttv.alice.mm_backend.channels.constants import scenario_name, scenario_slots
from smarttv.alice.mm_backend.channels.handler import get_run_response
from smarttv.alice.mm_backend.channels.matching import Matcher
from smarttv.alice.mm_backend.channels.channel import ChannelsManager
from smarttv.alice.mm_backend.common.views import MmRunView


class ChannelsView(MmRunView):
    scenario_name = scenario_name
    scenario_slots = scenario_slots
    tv_set_data_section = 'channels'

    def get_response(self, request_adapter):
        manager = ChannelsManager(request_adapter.tv_set[self.tv_set_data_section], 225)
        m = Matcher(manager.gallery)
        match_results = m.match(request_adapter.slots)
        return get_run_response(
            results=match_results,
            finder=manager,
            extra=request_adapter.tv_set[self.tv_set_data_section],
            user_req=request_adapter.slots['channel']
        )
