from collections import namedtuple

GalleryItem = namedtuple('GalleryItem', ('id', 'text'))


class Gallery:
    def __init__(self, items=None):
        self.items = items or []

    def add(self, id, text):
        self.items.append(GalleryItem(id, text))


class IGalleryBuilder:
    @property
    def gallery(self) -> Gallery:
        raise NotImplementedError
