from typing import Optional


class IItemFinder:
    def find_item(self, id) -> Optional:
        raise NotImplementedError


def get_item_attr(item: Optional, attr_name: str):
    if item:
        return getattr(item, attr_name)
    return None


def get_info(id, infos):
    for item in infos:
        inputs = item.get('list', [])
        for input in inputs:
            if input['id'] == id:
                return item

    assert False, 'id = %s not in infos: %s' % (id, infos)
