import logging

from google.protobuf import json_format
from rest_framework.parsers import JSONParser
from rest_framework.views import APIView

from smarttv.alice.mm_backend.common.adapters import AliceTvRequest
from smarttv.alice.mm_backend.common.adapters import NoDataException, InvalidClient
from smarttv.alice.mm_backend.common.proto_parser import MmProtoParser
from smarttv.alice.mm_backend.common.renderer import MmProtoRenderer
from smarttv.alice.mm_backend.common.response import mm_proto_response, irrelevant

logger = logging.getLogger(__name__)


class MmRunView(APIView):
    parser_classes = (JSONParser, MmProtoParser)
    renderer_classes = (MmProtoRenderer,)

    scenario_name = None
    scenario_slots = None
    tv_set_data_section = None

    def get_response(self, request_adapter):
        raise NotImplementedError

    # noinspection PyUnusedLocal
    def post(self, request, *args, **kwargs):
        request_object = request.data
        logger.debug('mm request: %s', request_object)

        request_adapter = AliceTvRequest(request_object)
        try:
            request_adapter.check(self.scenario_name, self.scenario_slots, self.tv_set_data_section)
        except (NoDataException, InvalidClient) as ex:
            logger.info(ex)
            return irrelevant

        run_response = self.get_response(request_adapter)

        logger.debug('back response: %s', json_format.MessageToJson(run_response))
        return mm_proto_response(run_response)
