# noinspection PyUnresolvedReferences
from alice.protos.data.language.language_pb2 import L_RUS
from alice.megamind.protos.scenarios.response_pb2 import TScenarioRunResponse

from smarttv.alice.mm_backend.common import livetv_url_scheme
from smarttv.alice.mm_backend.common.helpers import get_info, IItemFinder, get_item_attr
from smarttv.alice.mm_backend.inputs.constants import scenario_name, specifying_slot_name


class Phrases:
    digit2ordinal = {
        1: 'первый',
        2: 'второй',
        3: 'третий'
    }

    @staticmethod
    def success(x):
        return 'Переключаю на источник сигнала %s' % x

    @staticmethod
    def fail():
        return 'Я не нашла у вашего телевизора источника сигнала с таким названием.'

    @staticmethod
    def specify(x):
        return 'На вашем устройстве несколько устройств с похожим названием: %s, уточните какое из них вы имели в виду? Для уточнения скажите, например, первый.' % x


def add_hint_to(items, i):
    hint = items[str(i)].Instances.add()
    hint.Language = L_RUS
    assert i in Phrases.digit2ordinal
    hint.Phrase = Phrases.digit2ordinal[i]


def add_hints(entity, count):
    entity.Name = 'specify_%s' % specifying_slot_name

    for i in range(1, count + 1):
        add_hint_to(entity.Items, i)


def add_specifying_info(frame, slot_name, slot_type='string'):
    slot = frame.Slots.add()
    slot.Name = slot_name
    slot.Type = slot_type


def get_run_response(results, finder: IItemFinder, extra, user_req):
    def get_name(id):
        return get_item_attr(finder.find_item(id), 'name')

    run_response = TScenarioRunResponse()
    if len(results) == 0:
        run_response.ResponseBody.Layout.OutputSpeech = Phrases.fail()
    elif len(results) == 1:
        id = results[0]
        name = get_name(id)
        run_response.ResponseBody.Layout.OutputSpeech = Phrases.success(name)
        directive = run_response.ResponseBody.Layout.Directives.add()
        directive.OpenUriDirective.Name = 'live-tv inputs switcher'

        inputs_group_info = get_info(id, extra)
        directive.OpenUriDirective.Uri = livetv_url_scheme.switch_input_uri(
            inputs_group_info['authority'],
            inputs_group_info['input_type'],
            inputs_group_info['input_service'],
            id
        )
    else:
        inputs_names = ', '.join((get_name(id) for id in results))
        run_response.ResponseBody.Layout.OutputSpeech = Phrases.specify(inputs_names)
        frame = run_response.ResponseBody.SemanticFrame
        frame.Name = scenario_name

        add_specifying_info(frame, specifying_slot_name)
        add_hints(run_response.ResponseBody.Entities.add(), len(results))

    return run_response
