from collections import namedtuple
from typing import Optional

from smarttv.alice.mm_backend.common.gallery import IGalleryBuilder, Gallery, GalleryItem
from smarttv.alice.mm_backend.common.helpers import IItemFinder

Input = namedtuple('Input', ('id', 'name', 'device_name'))


class InputsManager(IGalleryBuilder, IItemFinder):
    def __init__(self, inputs_info):
        self.inputs = {}
        for info in inputs_info:
            for item in info['list']:
                self._add_input(item['id'], item['name'], item.get('device_name'))

    def _add_input(self, id, name: str, device_name: Optional):
        if device_name:
            device_name = device_name.lower()

        self.inputs[id] = Input(id, name.lower(), device_name)

    @property
    def gallery(self):
        def format(input):
            result = input.name
            if input.device_name:
                result += ' '
                result += input.device_name
            return result

        return Gallery([GalleryItem(item.id, format(item)) for item in self.inputs.values()])

    def find_item(self, id):
        return self.inputs.get(id)
