import logging
import re
from operator import itemgetter

from smarttv.alice.mm_backend.common.matcher import IMatcher

logger = logging.getLogger(__name__)


class Matcher(IMatcher):
    class Matcher(IMatcher):
        def __init__(self, gallery):
            super().__init__(gallery)

    def match(self, slots):
        source_id, number = itemgetter('source_id', 'number')(slots)

        re_str = source_id
        if number:
            re_str += r'\s*%d' % int(number)
        regexp = re.compile(re_str)

        logger.debug('input regexp for matching: "%s"', re_str)
        logger.debug('gallery items for matching: %s', self.gallery.items)

        found = filter(lambda x: regexp.search(x.text), self.gallery.items)
        return [item.id for item in found]
