from smarttv.alice.mm_backend.common.views import MmRunView
from smarttv.alice.mm_backend.inputs.constants import scenario_name, scenario_slots
from smarttv.alice.mm_backend.inputs.handler import get_run_response
from smarttv.alice.mm_backend.inputs.matching import Matcher
from smarttv.alice.mm_backend.inputs.input import InputsManager


class InputsView(MmRunView):
    scenario_name = scenario_name
    scenario_slots = scenario_slots
    tv_set_data_section = 'inputs'

    def get_response(self, request_adapter):
        manager = InputsManager(request_adapter.tv_set[self.tv_set_data_section])
        m = Matcher(manager.gallery)
        match_results = m.match(request_adapter.slots)
        return get_run_response(
            results=match_results,
            finder=manager,
            extra=request_adapter.tv_set[self.tv_set_data_section],
            user_req=None
        )
