import logging

import os

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
os.environ.setdefault("REQUESTS_CA_BUNDLE", '/etc/ssl/certs')

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'dcnm(34vnz4fs$u$vc75pm$yg2s*8ubq2vx=$q+-fl!&800ij)'

DEBUG = True

ALLOWED_HOSTS = ['*']

# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'smarttv.alice.mm_backend.channels',
    'smarttv.alice.mm_backend.inputs',
    'rest_framework',
]

ROOT_URLCONF = 'smarttv.alice.mm_backend.urls'

LANGUAGE_CODE = 'en-us'
USE_I18N = False

###########################
# Date and Time settings
TIME_ZONE = 'Europe/Moscow'
USE_TZ = True

# setting USE_L10N=False to use DATE_FORMAT and DATETIME_FORMAT for formatting instead of local formatting
USE_L10N = False
DATE_FORMAT = 'Y-m-d'
DATETIME_FORMAT = 'Y-m-d H:i:s'
###########################


# Logging
LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            'format': '[%(asctime)s] [%(process)d] [%(levelname)s] [%(name)s] %(message)s',
            'datefmt': '%Y-%m-%d %H:%M:%S',
            'class': 'logging.Formatter',
        },
        'raw': {
            'format': '%(message)s',
            'datefmt': '',
            'class': 'logging.Formatter',
        },
    },
    'handlers': {
        'console': {
            'class': 'logging.StreamHandler',
            'formatter': 'default',
        }
    },
    'loggers': {
        '': {
            'level': logging.DEBUG,
            'handlers': ['console'],
            'propagate': True
        },
    }
}

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.11/howto/static-files/
STATIC_ROOT = os.path.join(BASE_DIR, 'static')
STATIC_URL = '/static/'
