from django.conf import settings

from smarttv.alice.tv_proxy import log_context
from smarttv.alice.tv_proxy.proxy.headers import QUASAR_DEVICE_ID_HEADER, USER_IP_HEADER, USER_AGENT_HEADER
from smarttv.alice.tv_proxy.proxy.http import get_http_header


# todo: remove it after 2->3 python upgrade, use plus.utils.middleware versions
class FixEmptyHostMiddleware(object):
    def __init__(self, get_response):
        self.get_response = get_response

    def __call__(self, request):
        if 'HTTP_HOST' not in request.META and request.META.get('SERVER_NAME', '').startswith(':'):
            request.META['SERVER_NAME'] = 'localhost'

        response = self.get_response(request)
        return response


class LoggingContextMiddleware(object):
    DEFAULT_LOGGING_HEADERS = {
        'request_id': 'X-Request-Id',
        'quasar_device_id': QUASAR_DEVICE_ID_HEADER,
        'user_ip': USER_IP_HEADER,
        'user_agent': USER_AGENT_HEADER,
    }

    def __init__(self, get_response):
        self.get_response = get_response

    def __call__(self, request):
        log_context.clear()

        logging_headers = self.DEFAULT_LOGGING_HEADERS.copy()
        additional_logging_headers = getattr(settings, 'ADDITIONAL_LOGGING_HEADERS', None)
        if additional_logging_headers:
            logging_headers.update(additional_logging_headers)

        logging_kwargs = {
            'path': request.path,
            'host': request.get_host()
        }

        for parameter, header in logging_headers.items():
            header_value = get_http_header(request, header)
            if header_value:
                logging_kwargs[parameter] = header_value

        log_context.add(**logging_kwargs)
        return self.get_response(request)
