import logging

from rest_framework.exceptions import APIException
from rest_framework.views import exception_handler

logger = logging.getLogger(__name__)


# noinspection PyProtectedMember
def custom_exception_handler(exc, context):
    if isinstance(exc, APIException) and exc.status_code >= 500:
        logger.error('%s: %s', exc.__class__.__name__, exc.detail, exc_info=True)
    return exception_handler(exc, context)
