# -*- coding: utf-8 -*-

import logging
from time import time

from furl import furl

from django.core.management.base import BaseCommand
from smarttv.alice.tv_proxy.proxy.indexer import make_indexer_message, index, CabelChannelData, Cleaner, IndexingError

logger = logging.getLogger(__name__)

robot_device_id = 'ad4573c72b983fa5bf8ef9b440683d3f'


def make_url(channel_name):
    url = furl('live-tv://test-channel')
    url.args['name'] = channel_name
    return url.url


cable_channels = [
    'Первый канал',
    'Россия 1',
    'Матч ТВ',
    'НТВ',
    '5 канал',
    'Россия К',
    'Россия 24',
    'Карусель',
    'Общественное телевидение России',
    'ТВ Центр',
    'REN-TV',
    'Спас',
    'СТС',
    'Домашний',
    'ТВ 3',
    'Телекомпания Пятница',
    'Звезда',
    'Мир',
    'ТНТ',
    'Муз ТВ'
]


def make_channel_item(number, name):
    return {'number': number, 'name': name, 'uri': make_url(name)}


def get_channel_data():
    return [make_channel_item(*item) for item in enumerate(cable_channels, start=1)]


def get_time():
    return int(time())


class Command(BaseCommand):
    help = 'Index predetermined live tv channels'

    def add_arguments(self, parser):
        parser.add_argument('--device-id', default=robot_device_id)

    def handle(self, *args, **options):
        logger.info('Starting...')

        device_id = options['device_id']
        ts = get_time()
        channel_data = get_channel_data()

        try:
            messages = [
                make_indexer_message(CabelChannelData(item, device_id, ts), ts) for item in channel_data
            ]
            index(messages)

            cleaner = Cleaner(device_id)
            cleaner.rm_docs_earlier_than(ts)
        except IndexingError:
            logger.error('Failed to index')

        logger.info('Done')
