import logging

from rest_framework import exceptions
from smarttv.alice.tv_proxy.proxy.http import get_http_header

logger = logging.getLogger(__name__)


class RequestValidatorMixin(object):
    validator_class = None
    required_headers = None

    def get_validated_data(self, request):
        request_data = request.data or request.query_params
        validator = self.validator_class(data=request_data)
        validator.is_valid(raise_exception=True)
        return validator.validated_data

    def validate_headers(self, request):
        for header in self.required_headers:
            if not get_http_header(request, header):
                raise exceptions.ValidationError('%s is missing but required' % header)

    # noinspection PyUnresolvedReferences
    def initial(self, request, *args, **kwargs):
        if self.required_headers:
            self.validate_headers(request)
        super(RequestValidatorMixin, self).initial(request, *args, **kwargs)
