# -*- coding: utf-8 -*-

import re

synonims = {
    23: ['euronews', 'евроньюс'],
    25: ['music box'],
    161: ['360 канал'],
    313: ['russia today'],
    355: ['дойче велле'],
    681: ['тиви'],
    1333: ['универ'],
    1452: ['ю тв'],
    1759: ['хай тв', 'тиви'],
    1802: ['fresh tv'],
    1814: ['т номер'],
    1867: ['компания', 'кот'],
    1905: ['инкогнито'],
    1949: ['айва'],
    1548103434: ['1 внедорожный'],
}


def split_by_tv_ending(s):
    s = s.lower()
    s = re.sub(r'[-.]', ' ', s)
    s = re.sub(r'[(),!]', '', s)
    s = s.strip()

    if s.count(' ') > 0:
        return None

    end = s[-2:]
    if end in ('tv', 'тв'):
        return ' '.join((end, s[:-2]))

    return None
