from smarttv.utils.unistat import UnistatManager, TIMING_HGRAM_BINS

SUMM_COUNTERS = []
HGRAM_COUNTERS = []


class Status(object):
    _2xx = '2xx'
    _4xx = '4xx'
    _5xx = '5xx'
    error = 'error'
    parsing_error = 'parsing_error'
    retry = 'retry'


LB_SERVICE = 'lb'
SAAS_SERVICE = 'saas'

RESPONSE_STATUSES = (Status._2xx, Status._4xx, Status._5xx, Status.error, Status.parsing_error, Status.retry)
EXTERNAL_SERVICES = (LB_SERVICE, SAAS_SERVICE)


def get_request_counter_name(service, response_status):
    return 'request_{service}_{status}'.format(service=service, status=response_status)


for service in EXTERNAL_SERVICES:
    for response_status in RESPONSE_STATUSES:
        SUMM_COUNTERS.append(get_request_counter_name(service, response_status))

    HGRAM_COUNTERS.append((get_request_counter_name(service, 'timing'), TIMING_HGRAM_BINS))

manager = UnistatManager(SUMM_COUNTERS, HGRAM_COUNTERS)


class UnistatMixin(object):
    def __init__(self):
        self.unistat_counters = {}
        self.init_unistat_counters()

    def init_unistat_counters(self):
        if self.unistat_suffix not in EXTERNAL_SERVICES:
            return

        for status in RESPONSE_STATUSES:
            counter_name = get_request_counter_name(self.unistat_suffix, status)
            self.unistat_counters[status] = manager.get_counter(counter_name)

    def increment_unistat_counter(self, status, value=1):
        counter = self.unistat_counters.get(status)
        if counter is not None:
            counter.increment(value)

    def collect_unistat_metrics(self, response):
        if 200 <= response.status_code < 300:
            self.increment_unistat_counter(Status._2xx)
        elif 400 <= response.status_code < 500:
            self.increment_unistat_counter(Status._4xx)
        elif 500 <= response.status_code:
            self.increment_unistat_counter(Status._5xx)

        retry_count = len(response.raw.retries.history) if response.raw.retries else 0
        if retry_count > 0:
            self.increment_unistat_counter(Status.retry, retry_count)
