from rest_framework import serializers, fields


# noinspection PyAbstractClass
class Channel(serializers.Serializer):
    uri = fields.CharField(required=True)
    name = fields.CharField(required=True)
    number = fields.IntegerField(required=True)


# noinspection PyAbstractClass
class CabelChannelsTvMsgValidator(serializers.Serializer):
    channels = fields.ListField(child=Channel(), required=True)
    timestamp = fields.IntegerField(required=True, max_value=2147472000)  # 19.01.2038 00:00
