import os
import sys

from gunicorn.app.base import Application
from alice.nlu.py_libs.request_normalizer.request_normalizer import RequestNormalizer

os.environ.setdefault("DJANGO_SETTINGS_MODULE", "smarttv.droideka.settings")


class StandaloneApplication(Application):
    def init(self, parser, opts, args):
        pass

    def load(self):
        from django.core.wsgi import get_wsgi_application
        application = get_wsgi_application()

        # monkey-patch thread-local variable for correct work under gevent
        # https://st.yandex-team.ru/ADVISOR-1866
        from gevent.local import local
        import ylog
        ylog.context.ContextFormatter.thread_data = local()

        # start periodic task scheduler
        from smarttv.droideka.proxy.periodic_task import cache_update_task
        cache_update_task.start()

        # warm up normalizer
        RequestNormalizer.warm_up_singleton()

        return application


def main():
    # Unistat manager is initialized during import
    from smarttv.droideka import unistat  # noqa

    app = StandaloneApplication()
    app.run()


def manage():
    from django.core.management import execute_from_command_line
    execute_from_command_line(sys.argv)


if __name__ == "__main__":
    main()
