from redis_cache import RedisCache
from redis.sentinel import Sentinel


class RedisSentinelCache(RedisCache):
    def __init__(self, server, params):
        super(RedisCache, self).__init__(server, params)
        self.max_connections = self.options.get('MAX_CONNECTIONS', None)
        self.socket_keepalive = self.options.get('SOCKET_KEEPALIVE', True)
        self.health_check_interval = self.options.get('HEALTH_CHECK_INTERVAL', None)
        self.sentinel_socket_timeout = self.options.get('SENTINEL_SOCKET_TIMEOUT', None)
        self.retry_on_timeout = self.options.get('RETRY_ON_TIMEOUT', False)
        self.cluster_name = self.options.get('CLUSTER_NAME', None)
        self.check_connection = self.options.get('CHECK_CONNECTION', True)

        connection_kwargs = dict(
            db=self.db,
            password=self.password,
            max_connections=self.max_connections,
            socket_timeout=self.socket_timeout,
            socket_connect_timeout=self.socket_connect_timeout,
            socket_keepalive=self.socket_keepalive,
            health_check_interval=self.health_check_interval,
            retry_on_timeout=self.retry_on_timeout,
        )

        sentinel_kwargs = dict(socket_timeout=self.sentinel_socket_timeout)

        self.sentinel = Sentinel(self.servers, sentinel_kwargs=sentinel_kwargs, **connection_kwargs)
        self.master_client = self.sentinel.master_for(self.cluster_name, check_connection=self.check_connection)
        self.slave_client = self.sentinel.slave_for(self.cluster_name, check_connection=self.check_connection)

    def get_client(self, key, write=False):
        if write:
            return self.master_client
        return self.slave_client
