import os
import signal

bind = '[::]:80'
worker_class = 'gevent'
workers = int(os.getenv('GUNICORN_NUM_WORKERS', 1))
worker_connections = int(os.getenv('GUNICORN_WORKER_CONNECTIONS', 25))
backlog = int(os.getenv('GUNICORN_BACKLOG', workers * worker_connections))
timeout = 60

# Docker will wait only 10 seconds before hard shutdown
stophook_timeout = 20  # Check FAIL count = 3, Check interval = 2000 ms
graceful_timeout = stophook_timeout + 5

pidfile = '/var/run/gunicorn.pid'

access_log_format = ('%(t)s %({Host}i)s %({x-forwarded-for-y}i)s '
                     '"%(r)s" %(s)s %(l)s "%(a)s" %(l)s %(L)s %(l)s %(b)s %(l)s '
                     '"X-Request-Id: %({x-request-id}i)s" '
                     '"X-YaUUID: %({x-yauuid}i)s" '
                     '"X-Wifi-Mac: %({x-wifi-mac}i)s" '
                     '"X-Ethernet-Mac: %({x-ethernet-mac}i)s" '
                     '"Build-Fingerprint: %({build-fingerprint}i)s"')
logconfig = '/etc/gunicorn/logging.conf'

limit_request_line = 8190


def post_fork(server, worker):
    from psycogreen.gevent import patch_psycopg

    patch_psycopg()
    worker.log.info('Made Psycopg2 Green')


def post_worker_init(worker):
    from plus.utils.signals import log, stophook

    signal.signal(signal.SIGTERM, stophook.get_stop_signal_handler(worker, stophook_timeout))
    signal.signal(signal.SIGUSR1, log.get_logger_debug_handler())
    worker.log.debug('Signals registered')
