from abc import ABC, abstractmethod


class EndpointInfo(ABC):
    def __init__(self, api_version):
        self.api_version = api_version

    @property
    def api_prefix(self):
        return f'/api/v{self.api_version}/'

    @property
    def endpoint(self):
        return self.api_prefix + self.endpoint_name

    @property
    @abstractmethod
    def endpoint_name(self):
        pass

    @property
    @abstractmethod
    def params_200(self):
        pass


class Programs(EndpointInfo):
    endpoint_name = 'programs'
    params_200 = {'parent_id': '41a0f81e79c523d4a8e280aacc8b0e16'}


class Channels(EndpointInfo):
    endpoint_name = 'channels'
    params_200 = {}


class Categories(EndpointInfo):
    endpoint_name = 'categories'
    params_200 = {}


class Carousels(EndpointInfo):
    endpoint_name = 'carousels'
    params_200 = {'category_id': 'main'}


class Carousel(EndpointInfo):
    endpoint_name = 'carousel'
    params_200 = {'carousel_id': 'CATEG_FILM'}


class Doc2doc(EndpointInfo):
    endpoint_name = 'doc2doc'
    params_200 = {'content_id': '48863683b5ec3ad08474a73adab9a975', 'limit': 1}


class CardDetail(EndpointInfo):
    endpoint_name = 'card_detail'
    params_200 = {'content_id': '48863683b5ec3ad08474a73adab9a975'}


class CardDetailThin(EndpointInfo):
    endpoint_name = 'card_detail/thin'
    params_200 = {'content_id': '48863683b5ec3ad08474a73adab9a975'}


class CardDetailRatings(EndpointInfo):
    endpoint_name = 'card_detail/ratings'
    params_200 = {'content_id': '48863683b5ec3ad08474a73adab9a975'}


class Search(EndpointInfo):
    endpoint_name = 'search'
    params_200 = {'text': 'один плюс один'}


class ScreenSaver(EndpointInfo):
    endpoint_name = 'screensaver'
    params_200 = {'resolutions': 'HD', 'type': 'image'}


class SuggestHistory(EndpointInfo):
    endpoint_name = 'suggest_history'
    params_200 = {'text': 'оди'}
