from abc import ABC, abstractmethod

from smarttv.droideka.utils import PlatformType


class SmartTvClient(ABC):
    @property
    @abstractmethod
    def name(self):
        pass

    @property
    @abstractmethod
    def required_headers(self):
        pass


class Android(SmartTvClient):
    name = PlatformType.ANDROID

    required_headers = {
        'Host': 'droideka.tst.smarttv.yandex.net',
        'HTTP_X_YAUUID': 'd68c1bca4efa403313837b12f5cdcd26',
        'HTTP_USER_AGENT': 'com.yandex.tv.home/1.2.773 (Realtek SmartTV; Android 7.1.1)',
        'HTTP_X_ETHERNET_MAC': '00:11:22:33:44:55',
    }
