import logging
from typing import Tuple, Optional

import pytest
from copy import copy
from django.test import Client

logger = logging.getLogger(__name__)


required_android_headers = {
    'HTTP_USER_AGENT': 'com.yandex.tv.home/1.77.38.3271 (Hi VHIX-43U169MSY; Android 7.1.1)',
    'HTTP_X_YAUUID': 'd68c1bca4efa403313837b12f5cdcd26',
    'HTTP_X_YADEVICEID': 'ca9b68da30474d5db0bbd1e8a25565bb',
    'HTTP_X_YAQUASARDEVICEID': '001c578e343b1b000000',
    'HTTP_X_YAQUASARPLATFORM': 'yandex_tv_rt2871_hikeen',
    'HTTP_X_WIFI_MAC': '10:01:BB:00:10:10',
    'HTTP_X_ETHERNET-MAC': '01:ff:74:79:00:10',
    'HTTP_X_BUILD_FINGERPRINT': 'Hi/VHIX43U169MSY/VHIX43U169MSY:7.1.1/NMF26Q/1222:user/dev-keys',
    'HTTP_X_DEVICE_ICOOKIE': '1000051080704000000',
    'HTTP_X_FORWARDED_FOR': '5.45.209.55',
}


http_client = Client(content_type='application/json')


class TestApi:
    def check_get_response_codes(
            self, path: str, cgi_params: Optional[dict], headers: Optional[dict], expected_codes: Tuple[int]):
        required_headers = copy(required_android_headers)
        if headers:
            required_headers.update(headers)
        response = http_client.get(path, cgi_params, **required_headers)

        assert response.status_code in expected_codes
        assert response.json()

    @pytest.mark.parametrize('search_text', [
        'Внутри Лапенко',
        'Бригада',
        'Томирис фильм',
        'Игра пресотлов',
        'Убить пересмешника фильм',
        '1+1',
        'Великолепный век',
    ])
    def test_search_200(self, search_text: str):
        self.check_get_response_codes('/api/v7/search', {'text': search_text}, None, (200,))

    @pytest.mark.parametrize('search_text', [
        'Внутри Лапенко',
        'Бригада',
        'Томирис фильм',
        'Игра пресотлов',
        'Убить пересмешника фильм',
        '1+1',
        'Великолепный век',
    ])
    def test_alice_search_200(self, search_text: str):
        self.check_get_response_codes('/api/v7/alice/search', {'text': search_text}, None, (200,))
