import os

import requests

from yql.api.v1.client import YqlClient
import yt.wrapper as yt
from yt.wrapper.ypath import ypath_join


def generate(ammo_file, log_date, yt_token, yql_token):
    YT_PROXY = 'arnold.yt.yandex.net'
    YT_ROOT = 'logs/smarttv-external-balancer-access-log/1d'

    YT_CONFIG = {
        'proxy': {'url': YT_PROXY},
        'token': yt_token,
        'force_using_yson_for_formatted_requests': False,
    }

    yt.update_config(YT_CONFIG)

    yql_client = YqlClient(token=yql_token)

    query = '''USE arnold;
PRAGMA yt.UseNativeYtTypes = '1';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
SELECT request_id, process_time, client_ip, request, headers
FROM `{log_path}`
WHERE domain="droideka.smarttv.yandex.net" AND method="GET" AND status!=403
LIMIT 20000'''

    yt_path = ypath_join(YT_ROOT, log_date)
    print(f'Selecting YT path: {yt_path}')

    request = yql_client.query(
        query.format(
            log_path=ypath_join(YT_ROOT, log_date)
        ),
        syntax_version=1,
        title='YQL: Fetch droideka requests for making ammo',
    )

    request.run()
    results = request.get_results()
    if results.status != 'COMPLETED':
        raise RuntimeError(repr(results.errors))

    for table in results:
        records = table.get_iterator()
        with open(ammo_file, 'w') as af:
            af.write('[Host: droideka.pre.smarttv.yandex.net]\n')
            for req_id, process_time, client_ip, request_path, headers in records:
                af.write(f'[X-Real-IP: {client_ip}]\n')
                for key in headers:
                    af.write(f'[{key}: {headers[key]}]\n')
                af.write(f'{request_path}\n')


def upload(ammo_file, description):
    url = 'https://lunapark.yandex-team.ru/api/addammo.json'
    login = os.getenv('YA_USER') or os.getenv('USER')
    response = requests.post(url, data={
        'login': login,
        'dsc': description,
    }, files={
        'file': (ammo_file, open(ammo_file, 'rb'), 'text/plain'),
    })
    response.raise_for_status()
    result = response.json()
    if result[0]['success']:
        return result[0]['url']
    raise RuntimeError(response.text)
