import argparse
from datetime import date, timedelta

from smarttv.droideka.load import ammo
from library.python.vault_client.instances import Production as VaultClient


def main():
    parser = argparse.ArgumentParser(description='Make ammo for droideka load')
    parser.add_argument('-d', '--date', action='store', dest='date',
                        default=(date.today() - timedelta(days=1)).isoformat(),
                        help='Date for requests log table in format "YYYY-MM-DD" [default: <yesterday>]')
    parser.add_argument('-f', '--file', action='store', type=str, dest='file',
                        default=None,
                        help='File to save ammo [default: ammo-<date>.txt]')
    parser.add_argument('-u', '--upload', action='store_true', dest='upload',
                        default=False,
                        help='Upload ammo file to Lunapark MDS [default: false]')
    args = parser.parse_args()
    ammo_file = args.file or f'ammo-{args.date}.txt'

    client = VaultClient(decode_files=True)
    yt_token = client.get_version('sec-01egnbe7sa18ey27z7qt5hw0nr')['value']['robot-smart-tv-yt-token']
    yql_token = client.get_version('sec-01ex7213fpfz74qk2zy58ywn01')['value']['YQL_TOKEN']

    ammo.generate(ammo_file, args.date, yt_token, yql_token)
    print(f'\nAmmo file "{ammo_file}" generated')
    if args.upload:
        ammo_dsc = f'Droideka ammo [{args.date}]'
        ammo_url = ammo.upload(ammo_file, ammo_dsc)
        print(f'Ammo file uploaded with name "{ammo_dsc}" to "{ammo_url}"')


if __name__ == '__main__':
    main()
