# flake8 noqa: F401
from django.conf import settings
from smarttv.droideka.proxy.api import vs, es, vh, ott, usaas, music, alice, memento, smotreshka

if settings.THROTTLE_EXTERNAL_API:
    from functools import update_wrapper, partial
    from smarttv.droideka.proxy.api.base import ApiSampler
    sampler = ApiSampler(settings.THROTTLE_FAKE_TO_REAL_RATE)
    sampler.patch_request(es.client)
    sampler.patch_request(ott.client, func_name='metadata')
    sampler.patch_request(ott.client, func_name='children')
    sampler.patch_request(ott.client, func_name='selections')
    sampler.patch_request(ott.client, func_name='multi_selections')
    sampler.patch_request(ott.client, func_name='purchases')
    sampler.patch_request(vh.client, by_endpoint=True)
    sampler.patch_request(vs.client)
    sampler.patch_request(vs.history)

    USAAS_MOCK_RESPONSE = {
        "all": {"CONTEXT": {"MAIN": {}}},
        "exp_boxes": ""
    }
    usaas.client._request = lambda *args, **kwargs: USAAS_MOCK_RESPONSE

    def sampler_method_decorator(by_endpoint_or_method):
        by_endpoint = False if callable(by_endpoint_or_method) else by_endpoint_or_method

        def method_wrapper(method):
            def _wrapper(self_, *args, **kwargs):
                bound_method = method.__get__(self_, type(self_))
                wrapper = sampler.wrap(by_endpoint=by_endpoint)
                wrapped_func = wrapper(bound_method)
                return wrapped_func(*args, **kwargs)

            return update_wrapper(_wrapper, method)

        if callable(by_endpoint_or_method):
            return method_wrapper(by_endpoint_or_method)

        return method_wrapper

else:
    def sampler_method_decorator(by_endpoint_or_method):
        def method_wrapper(method):
            return method
        if callable(by_endpoint_or_method):
            return by_endpoint_or_method
        return method_wrapper
