"""
Yandex.Alice b2b api client
"""
from typing import Any, Optional, List

from django.conf import settings

from smarttv.droideka.proxy.api import base
from smarttv.droideka.proxy.tvm import add_service_ticket


class AliceBusinessApi(base.BaseJsonApi):
    unistat_suffix = 'aliceb2b'

    class ResponseError(Exception):
        pass

    def update_headers(self, headers):
        headers = super().update_headers(headers)
        headers = add_service_ticket(settings.ALICE_BUSINESS_CLIENT_ID, headers)
        return headers

    def retrieve_result(self, raw_response):
        if raw_response and 'result' in raw_response:
            return raw_response['result']

        raise self.ResponseError(f'Invalid device info response: {raw_response}')

    # todo: pass common headers like X-Request-Id

    def device_info(self, quazar_id: str) -> Optional[dict[str, Any]]:
        """
        Hotel promo card infomation for device by quazar id
        """
        params = {
            'device_id': quazar_id,
        }

        response = self._request('GET', 'droideka/device_info', params=params)

        return self.retrieve_result(response)

    def devices(self) -> List[str]:
        return self.retrieve_result(self._request('GET', 'droideka/devices'))


client = AliceBusinessApi(
    url=settings.ALICE_BUSINESS_API_URL,
    timeout=settings.ALICE_BUSINESS_DEFAULT_TIMEOUT,
    retries=settings.ALICE_BUSINESS_DEFAULT_RETRIES,
)
