"""
Entity search API client
"""
import logging
from django.conf import settings

from smarttv.droideka.proxy.api import base
from smarttv.droideka.proxy.api.access_config import get_access_config

logger = logging.getLogger(__name__)


OO_CONTENT_TYPE_SERIES = 'TV_SERIES'
OO_CONTENT_TYPE_EPISODE = 'MOVIE'


OO_CONTENT_TYPES = (OO_CONTENT_TYPE_SERIES, OO_CONTENT_TYPE_EPISODE)


class EntitySearchApi(base.BaseJsonApi):
    unistat_suffix = 'entity'

    def get_client(self, request) -> str:
        return get_access_config(request).object_response_client

    def get_object_response(self, request, obj_id_list=None, ento=None, headers=None, passport_uid=None):
        if not obj_id_list and not ento:
            logger.error('Nothing to load')
            return None

        params = {
            'format': 'json',
            'client': self.get_client(request)
        }
        if obj_id_list:
            params['obj'] = ','.join(obj_id_list)

        if ento:
            params['ento'] = ento

        if passport_uid:
            params['uid'] = passport_uid

        return self._request(headers=headers, params=params)


client = EntitySearchApi(
    url=settings.ENTITY_SEARCH_API_URL,
    timeout=settings.ENTITY_SEARCH_DEFAULT_TIMEOUT,
    retries=settings.ENTITY_SEARCH_DEFAULT_RETRIES,
)
