from django.conf import settings
from smarttv.droideka.proxy.api.base import BaseRpcApi
from alice.memento.proto.api_pb2 import TReqGetUserObjects, TRespGetUserObjects, TReqChangeUserObjects, \
    TRespChangeUserObjects


class MementoContentApi(BaseRpcApi):
    unistat_suffix = 'memento'
    url_prefix = '/memento'

    def get_objects(self, request_data: TReqGetUserObjects, headers: dict) -> TRespGetUserObjects:
        path = f'{self.url_prefix}/get_objects'
        return self._request(
            method='POST', endpoint=path, headers=headers, data=request_data.SerializeToString(),
            response_class=TRespGetUserObjects)

    def update_objects(self, request_data: TReqChangeUserObjects, headers: dict) -> TRespChangeUserObjects:
        path = f'{self.url_prefix}/update_objects'
        return self._request(
            method='POST', endpoint=path, headers=headers, data=request_data.SerializeToString(),
            response_class=TRespChangeUserObjects)


client = MementoContentApi(
    settings.MEMENTO_URL,
    timeout=settings.MEMENTO_DEFAULT_TIMEOUT,
    retries=settings.MEMENTO_DEFAULT_RETRIES,
)
