"""
Yandex.Music API client
"""
import logging
from django.conf import settings

from smarttv.droideka.proxy.api import base

logger = logging.getLogger(__name__)


class MusicApi(base.BaseJsonApi):
    unistat_suffix = 'music'
    valid_response_codes = (400, 401)
    landing_type = 'yandex_tv'

    def infinite_feed(self, headers=None) -> dict:
        params = {
            'landingType': self.landing_type,
            'supportedBlocks': 'generic',
        }

        return self._request('GET', 'infinite-feed', params=params, headers=headers)

    def handle_status(self, response, **kwargs):
        if response.status_code in self.valid_response_codes:
            logger.info('Music handled response %s: %s', response.status_code, response.content)
            # response will be processed in data source, continue
            return

        super().handle_status(response, **kwargs)


client = MusicApi(
    url=settings.MUSIC_API_URL,
    timeout=settings.MUSIC_DEFAULT_TIMEOUT,
    retries=settings.MUSIC_DEFAULT_RETRIES,
)
