import logging

from cache_memoize import cache_memoize
from django.conf import settings
from smarttv.droideka.proxy.models import Cinema

DEFAULT_DICT = {}
logger = logging.getLogger(__name__)


class CinemaDatabase:
    """
    Интерфейс к списку сторонних кинотеатров

    Через админку можно включить или выключить отображение каждого кинотеатра.
    """

    def get_allowed_cinema_codes(self):
        return [code for code, cinema in self.load_database().items() if cinema['enabled']]

    @cache_memoize(
        timeout=settings.DEFAULT_RESPONSE_CACHE_TIME,
        cache_alias='local',
    )
    def load_database(self):
        result = {}
        for record in Cinema.objects.values('code', 'enabled', 'icon'):
            result[record['code']] = record
        return result

    def get_admin_favicon(self, code):
        cinemas = self.load_database()
        if code in cinemas:
            return cinemas[code]['icon']


cinema_db = CinemaDatabase()
