FILTERABLE_CAROUSEL_ID = 'CATEG_NAVIGATION_VIDEO'
CAROUSELS_WITH_FILTERS = ('CATEG_FILM', 'CATEG_SERIES')
TAG_BY_CAROUSEL_MAPPING = {'CATEG_FILM': 'movie', 'CATEG_SERIES': 'series'}
EMBEDDED_SECTION_TYPE = 'embedded_section'
COMPOSITE_FEED = 'composite_feed'

# OTT selections API has 2 id: selection_id, and window id
# Droideka mechanism for selecting OTT's selections requires both of them. Based on these ids, we can obtain the final
# position of carousel, title, and other parameters
# But some of OTT API's has no these ids. They has hardcoded paths
# Because they have the same output format, it's better to integrate it as other KP selections but with small addition -
# hardcoding id's for them
# this is general window id for such carousels
DROIDEKA_INTERNAL_OTT_WINDOW_ID = 'droideka_internal'

PURCHASES_FAKE_SELECTION_ID = 'purchases'
PURCHASES_CAROUSEL_ID = f'{DROIDEKA_INTERNAL_OTT_WINDOW_ID}/{PURCHASES_FAKE_SELECTION_ID}'


class VhFeed:
    TYPE = ''

    FIELD_CATEGORY_ID = 'category_id'
    FIELD_CACHE_HASH = 'cache_hash'
    FIELD_MAX_ITEMS_COUNT = 'max_items_count'
    FIELD_MORE = 'more'


class VhCarousel:
    TYPE = 'vh_carousel'

    FIELD_CAROUSEL_ID = 'carousel_id'
    FIELD_DOCS_CACHE_HASH = 'docs_cache_hash'
    FIELD_FILTER = 'filter'
    FIELD_TAG = 'tag'
    FIELD_MORE_INFO = 'more_info'
    FIELD_MORE_URL = 'url'

    CATEGORY_CHANNELS = 'channels'


class KpCarousel:
    FIELD_PAGING_META = 'pagingMeta'
    FIELD_HAS_MORE = 'hasMore'
    FIELD_SESSION_ID = 'sessionId'
    TYPE = 'external_kp'


class KpCategory:
    TYPE = 'external_category_kp'


class MusicCarousel:
    TYPE = 'music_main_carousel'


class MusicCategory:
    TYPE = 'music_category'


class CarouselsExternal:
    """
    Contains constants related to external carousels(non-VH carousels)
    """

    KEY_CAROUSEL_TYPE = 'carousel_type'

    TYPES = (KpCarousel.TYPE,)

    FIELD_EXTERNAL_CAROUSEL_OFFSET = 'external_carousel_offset'
    FIELD_CAROUSEL_TYPE = 'carousel_type'


class KpMultiSelection:
    CAROUSEL_CONTENT_TYPE = 'embedded_carousel'

    FIELD_MULTISELECTION_URL = 'url'


class PaginationFieldsMixin:
    FIELD_LIMIT = 'limit'
    FIELD_OFFSET = 'offset'
    FIELD_MORE_URL_LIMIT = 'more_url_limit'


class KidModeFieldsMixin:
    FIELD_RESTRICTION_AGE = 'restriction_age'
    FIELD_KID_MODE = 'kid_mode'


class DroidekaCarousel(PaginationFieldsMixin, KidModeFieldsMixin):
    """
    Constant keys of serializer: :class:`smarttv.droideka.proxy.serializers.serializers.CarouselValidator`
    """
    FIELD_CAROUSEL_ID = 'carousel_id'
    FIELD_CACHE_HASH = 'docs_cache_hash'
    FIELD_CAROUSEL_TYPE = 'carousel_type'
    FIELD_FILTER = 'filter'
    FIELD_TAG = 'tag'
    FIELD_AVAILABLE_ONLY = 'available_only'

    FIELD_MORE_INFO = 'more_info'
    FIELD_MORE_URL = 'url'


class DroidekaCategory(PaginationFieldsMixin):
    """
    Constant keys of serializer: :class:`smarttv.droideka.proxy.serializers.serializers.CarouselsValidator`
    """
    FIELD_CATEGORY_ID = 'category_id'
    FIELD_MAX_ITEMS_COUNT = 'max_items_count'
    FIELD_CACHE_HASH = 'cache_hash'
    FIELD_MORE_URL = 'more'


class CarouselType:
    """
    Constants, which tell to client, how carousel should be displayed(which design to use for certain carousel)
    """
    TYPE_SQUARE = 'square'  # indicated that carousel should have square like elements
    TYPE_SQUARE_BIG = 'square_big'  # indicated that carousel should have square like elements


class ActionItem:
    """
    Item type used in PromoZalogin and Hotel carousel items
    Used to store deep-links
    """
    TYPE = 'action'
