import logging

from rest_framework import status
from rest_framework.exceptions import APIException, NotFound as NotFoundError, PermissionDenied as PermissionDeniedError, ParseError as BadRequestError  # noqa
from rest_framework.views import exception_handler

logger = logging.getLogger(__name__)


# noinspection PyProtectedMember
def custom_exception_handler(exc, context):
    if isinstance(exc, APIException) and exc.status_code >= 500:
        logger.error('%s: %s', exc.__class__.__name__, exc.detail, exc_info=True,
                     extra={'request': context['view'].request._request})
    return exception_handler(exc, context)


class InternalServerError(APIException):
    pass


class BadGatewayError(APIException):
    status_code = status.HTTP_502_BAD_GATEWAY


class GatewayTimeoutError(APIException):
    status_code = status.HTTP_504_GATEWAY_TIMEOUT


class PlatformNotSupported(APIException):
    status_code = status.HTTP_405_METHOD_NOT_ALLOWED


class ForbiddenError(APIException):
    status_code = status.HTTP_403_FORBIDDEN


class NoMoreError(ValueError):
    """
    Indicates more url shouldn't be used
    """
    pass
