import logging

from smarttv.droideka import unistat
from smarttv.droideka.proxy import api, cache
from smarttv.droideka.protos.profile.profile_pb2 import TUserProfile


logger = logging.getLogger(__name__)
kp_profile_activation_counter = unistat.manager.get_counter('kp_profile_activation')


def _mark_profile_created(puid: str, user_profile: TUserProfile):
    try:
        user_profile.KpProfileRegistered = True
        cache.user_profile.set(puid, user_profile)
    except Exception:
        logger.exception('Error marking user profile as created')


def ensure_created(puid: str, headers: dict, request):
    user_profile = cache.user_profile.get(puid)
    if user_profile and user_profile.KpProfileRegistered:
        logger.debug('No need to auto create KP profile')
        return
    if not user_profile:
        user_profile = TUserProfile()
    try:
        api.ott.client.create_kp_profile(headers, request)
        _mark_profile_created(puid, user_profile)
        logger.info('KP profile created for user: %s', puid)
        kp_profile_activation_counter.increment()
    except api.base.BaseApi.ConflictError:
        logger.info('ConflictError: KP profile already created')
        _mark_profile_created(puid, user_profile)
    except Exception as exc:
        # Do not fail request in any error
        logger.error('Error creating profile for user: %s, error: %s', puid, exc)
