from datetime import datetime

from django.core.management.base import BaseCommand


class Command(BaseCommand):
    help = 'Provides unique S3 key for programs archive'

    S3_PROGRAMS_DIR = 'programs'

    @classmethod
    def get_upload_zip_file_name(cls):
        now = datetime.now()
        return f'{now.year}_{now.month}_{now.day}_{now.hour}_{now.minute}_{now.second}_programs.zip'

    @classmethod
    def get_s3_upload_key(cls):
        return f'{cls.S3_PROGRAMS_DIR}/{cls.get_upload_zip_file_name()}'

    def handle(self, *args, **options):
        self.stdout.write(self.get_s3_upload_key())
