from smarttv.droideka.proxy import models

from django.core.management.base import BaseCommand
from smarttv.droideka.proxy.constants.reserved_shared_pref_keys import KEY_PROGRAMS_ARCHIVE_S3_KEY


class Command(BaseCommand):
    help = 'Provides unique S3 key for programs archive'

    ARG_S3_KEY = 's3_key'

    def add_arguments(self, parser):
        parser.add_argument(f'--{self.ARG_S3_KEY}', help='S3 Key of programs archive(if "s3_url" not passed)',
                            required=False)

    def handle(self, *args, **options):
        s3_key = options.get(self.ARG_S3_KEY, None)
        if not s3_key:
            raise ValueError("'s3_key' must be specified")
        models.SharedPreferences.put_string(KEY_PROGRAMS_ARCHIVE_S3_KEY, s3_key)
