# -*- coding: utf-8 -*-
# Generated by Django 1.11.28 on 2020-03-17 14:46
from __future__ import unicode_literals

from django.db import migrations, models


def delete_duplicates(apps, schema_editor):
    Device = apps.get_model('proxy', 'Device')
    db_alias = schema_editor.connection.alias
    duplicate_devices = Device.objects.using(db_alias) \
        .values('serial_number') \
        .annotate(serial_number_count=models.Count('serial_number')) \
        .filter(serial_number_count__gt=1)
    for device in duplicate_devices:
        duplicates_pk = Device.objects.using(db_alias) \
                            .filter(serial_number=device['serial_number']) \
                            .order_by('pk') \
                            .values_list('id', flat=True)[1:]
        Device.objects.using(db_alias).filter(pk__in=duplicates_pk).delete()


class Migration(migrations.Migration):
    dependencies = [
        ('proxy', '0003_auto_20200219_1635'),
    ]

    operations = [
        migrations.RunPython(
            code=delete_duplicates,
            reverse_code=migrations.RunPython.noop
        ),
        migrations.AlterField(
            model_name='device',
            name='serial_number',
            field=models.CharField(max_length=256, unique=True, verbose_name='Серийный номер'),
        ),
    ]
