# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-06-08 16:06
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import smarttv.droideka.proxy.models


class Migration(migrations.Migration):

    dependencies = [
        ('proxy', '0010_auto_20200526_0904'),
    ]

    operations = [
        migrations.CreateModel(
            name='CategoryExtended',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('category_id', models.CharField(max_length=64, verbose_name='ID категории')),
                ('title', models.CharField(max_length=128, verbose_name='Имя категории')),
                ('icon_s3_key', models.TextField(blank=True, null=True, verbose_name='Key S3 иконки')),
                ('rank', models.IntegerField(verbose_name='Позиция в выдаче')),
                ('thumbnail_s3_key', models.TextField(blank=True, null=True, verbose_name='Ключ S3 превью')),
                ('logo_s3_key', models.TextField(blank=True, null=True, verbose_name='Ключ S3 логотипа')),
                ('banner_S3_key', models.TextField(blank=True, null=True, verbose_name='Key S3 баннера')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Описание категории')),
                ('content_type', models.TextField(blank=True, null=True, verbose_name='Тип категории')),
                ('visible', models.BooleanField(default=True)),
                ('version', models.IntegerField(verbose_name='Version')),
            ],
            options={
                'verbose_name_plural': 'Extended categories',
                'ordering': ('rank',),
            },
            bases=(models.Model, smarttv.droideka.proxy.models.EntityMixin),
        ),
        migrations.CreateModel(
            name='PlatformModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('platform_type', models.CharField(choices=[('web', 'web'), ('android', 'android'), ('any', 'any'), ('none', 'none')], max_length=32, verbose_name='Тип платформы')),
                ('platform_name', models.CharField(blank=True, max_length=64, null=True, verbose_name='Название платформы')),
                ('platform_version', models.IntegerField(blank=True, null=True, verbose_name='Версия платформы')),
                ('build_version', models.IntegerField(blank=True, null=True, verbose_name='Номер сборки')),
            ],
            options={
                'verbose_name_plural': 'Platforms',
                'ordering': ('platform_type', 'platform_name', 'platform_version', 'build_version'),
            },
            bases=(models.Model, smarttv.droideka.proxy.models.EntityMixin),
        ),
        migrations.AddField(
            model_name='categoryextended',
            name='above_platforms',
            field=models.ManyToManyField(related_name='proxy_categoryextended_above_platforms', related_query_name='proxy_categoryextendeds_above', to='proxy.PlatformModel'),
        ),
        migrations.AddField(
            model_name='categoryextended',
            name='below_platforms',
            field=models.ManyToManyField(related_name='proxy_categoryextended_below_platforms', related_query_name='proxy_categoryextendeds_below', to='proxy.PlatformModel'),
        ),
        migrations.AddField(
            model_name='categoryextended',
            name='exclude_platforms',
            field=models.ManyToManyField(related_name='proxy_categoryextended_exclude_platforms', related_query_name='proxy_categoryextendeds_exclude', to='proxy.PlatformModel'),
        ),
        migrations.AddField(
            model_name='categoryextended',
            name='include_platforms',
            field=models.ManyToManyField(related_name='proxy_categoryextended_include_platforms', related_query_name='proxy_categoryextendeds_include', to='proxy.PlatformModel'),
        ),
        migrations.AddField(
            model_name='categoryextended',
            name='parent_category_id',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='proxy.CategoryExtended'),
        ),
        migrations.AlterUniqueTogether(
            name='categoryextended',
            unique_together=set([('category_id', 'parent_category_id', 'version')]),
        ),
    ]
